
%% Initialize the device

% open the device on the localhost , port 9999

% device = tcpclient('127.0.0.1', 9999);      % for the latest Matlab
device = tcpip('localhost', 9999);          % for older versions
fopen (device);
pause (0.1)

%% Read the server response

bytesav = get(device, 'bytesavailable');
msg = fread(device, bytesav);
msgstr = char(msg);
msgstr = convertCharsToStrings(msgstr);

%% Step 15-16

% ----------------------------------------------------------------------- %
% Complete the following code:
% Set the parameters to control the voltage and integration time of SPAD23.

voltage = 'FILL HERE';              % Operating voltage. Unit: V.

integration_time = 'FILL HERE';     % Integration time. Unit: ms.

% ------------------------------ END ------------------------------------ %

Set_Voltage(device,voltage);

[msgvals] = Set_Int_Time_Get_Count_Rates( ...
    device, integration_time ...
);

counts = msgvals(2 ,:);

% Plot the figure
figure
plot(1:1:23, counts, '-o', 'LineWidth', 3, 'MarkerSize', 10)
xlabel('Pixel Number')
ylabel('Counts [cps]')


%% Step 17-18

% ----------------------------------------------------------------------- %
% Complete the following code:
% Set the parameters to control the voltage and integration time of SPAD23.

voltage = 'FILL HERE';              % Operating voltage. Unit: V.

integration_time = 'FILL HERE';     % Integration time. Unit: ms.

num_iteration = 'FILL HERE';        % Number of iterations.

% ------------------------------ END ------------------------------------ %

Set_Voltage(device,voltage);

all_counts = zeros(num_iteration,1);
all_counts_excl = zeros(num_iteration,1);

for i = 1:1:num_iteration
    [msgvals] = Set_Int_Time_Get_Count_Rates( ...
        device, integration_time ...
    );

    % ------------------------------------------------------------------- %
    % Complete the following code:
    % Calculate the mean counts of pixels including and exclusing hot
    % pixels

    counts = 'FILL HERE';
    counts_excl = 'FILL HERE';

    % ----------------------------- END --------------------------------- %

    % Save the counts
    all_counts(i) = counts;
    all_counts_excl(i) = counts_excl;

end

% Plot the figure

figure

plot(1:1:num_iteration, all_counts,'-o','LineWidth',3,'MarkerSize',10)
hold on
plot(1:1:num_iteration, all_counts_excl,'-ro','LineWidth',3,'MarkerSize',10)
xlabel("iterations ")
ylabel("mean DCR [cps]")
legend('mean DCR', 'mean DCR excl. hot pixel')

%% Step 19-21

% ----------------------------------------------------------------------- %
% Complete the following code:
% Set the parameters to control the voltage and integration time of SPAD23.

voltage = 'FILL HERE';              % Operating voltage. Unit: V.

integration_times = 'FILL HERE';    % Integration time.
                                    % Unit: ms. Max: 2400 ms
                                    % format: initVal:step:endVal

num_iteration = 'FILL HERE';        % Number of iterations.

% ------------------------------ END ------------------------------------ %

Set_Voltage(device,voltage);

all_stds_excl = zeros(length(integration_times),1);

% loop over integration times
for idx = 1:1:length(integration_times)

    all_counts_excl = zeros(num_iteration,1);

    % loop over iterations
    for i = 1:1:num_iteration
        [msgvals] = Set_Int_Time_Get_Count_Rates( ...
            device, integration_times(idx) ...
        );

        counts_excl = ...
            mean(msgvals(2,2:end)) / integration_times(idx) * 1e3;

        % Save the counts
        all_counts_excl(i) = counts_excl;

    end

    all_stds_excl(idx) = std(all_counts_excl);
end

% Plot standard deviation for each integration time - Step 20

figure
plot( integration_times , all_stds_excl,'-ro','LineWidth',3,'MarkerSize',10)
xlabel("Integration Time [ms]")
ylabel("Standard deviation")

%% Step 22-25

% ----------------------------------------------------------------------- %
% Complete the following code:
% Set the parameters to control the voltage and integration time of SPAD23.

voltages = 'FILL HERE';             % Operating voltage. max: 31.5
                                    % Format: initVal:step:endVal

integration_time = 'FILL HERE';     % Integration time. Unit: ms.

num_iteration = 'FILL HERE';        % Number of iterations.

% ------------------------------ END ------------------------------------ %

all_voltages_excl = zeros(length(voltages), 1);

% loop over voltages
for idx = 1:1:length(voltages)

    Set_Voltage(device,voltages(idx));

    all_counts_excl = zeros(num_iteration,1);

    % loop over iterations
    for i = 1:1:num_iteration
        [msgvals] = Set_Int_Time_Get_Count_Rates( ...
            device, integration_time ...
        );

        counts_excl = ...
            mean(msgvals(2,2:end)) / integration_time * 1e3;

        % Save the counts
        all_counts_excl(i) = counts_excl;
    end

    all_voltages_excl(idx) = mean(all_counts_excl);
end

figure
plot(voltages , all_voltages_excl,'-o','LineWidth',3,'MarkerSize',10)
xlabel(" Voltage [v]")
ylabel(" DCR [cps]")    
 